<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Razzi
 */

require_once get_template_directory() . '/inc/class-razzi-theme.php';

\Razzi\Theme::instance();

add_filter( 'woocommerce_get_price_html', 'hide_price', 99, 2 );

function hide_price( $price, $product ) {
    $precio_dolar = get_option( 'precio_dolar', '' );
    $monto_real = 0; // Inicializamos la variable con un valor numérico predeterminado
    $product_price = $product->get_price(); // Obtenemos el precio del producto

    // Validamos que 'precio_dolar' y el precio del producto sean numéricos
    if ( is_numeric( $precio_dolar ) && is_numeric( $product_price ) ) {
        $monto_real = $precio_dolar * $product_price;
    }
    
    // Aseguramos que $monto_real es numérico antes de formatearlo
    if ( ! is_numeric($monto_real) ) {
        $monto_real = 0; // Si no es un número, lo establecemos en 0
    }

    $monto_real = number_format($monto_real, 2);
    $price .= ' - Bs.'.$monto_real.'';
    return $price;
}

add_filter('admin_init', 'precio_dolar_fields');
function precio_dolar_fields()
{
register_setting('general', 'precio_dolar', 'esc_attr');

add_settings_field('precio_dolar', '<label for="precio_dolar">'.__('Tasa Dolar' , 'precio_dolar' ).'</label>' , 'precio_dolar_html', 'general');
}


function precio_dolar_html()
{
$value = get_option( 'precio_dolar', '' );
echo '<input type="text" id="precio_dolar" name="precio_dolar" value="' . $value . '" />';
}