<?php
/**
 * Template part for modal account
 *
 * @package Razzi
 */

?>
<div class="modal-header">
    <h3 class="modal-title"><?php esc_html_e( 'Sign in', 'razzi' ) ?></h3>
    <a href="#" class="close-account-panel button-close"><?php echo \Razzi\Icon::get_svg( 'close' ); ?></a>
</div>

<div class="modal-content">
    <form class="woocommerce woocommerce-account woocommerce-form woocommerce-form-login login" method="post">

		<?php do_action( 'woocommerce_login_form_start' ); ?>

        <p class="form-row form-row-wide">
            <input  placeholder="<?php  esc_attr_e( 'Username', 'razzi' );?>" type="text" class="input-text" name="username" id="panel_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" required aria-required="true" />
        </p>
        <p class="form-row form-row-wide">
            <span class="password-input">
                <input placeholder="<?php  esc_attr_e( 'Password', 'razzi' );?>" class="input-text" type="password" name="password" id="panel_password" autocomplete="current-password" required aria-required="true" />
            </span>
        </p>

		<?php do_action( 'woocommerce_login_form' ); ?>

        <p class="form-row form-row-wide form-row-remember">
            <label class="woocommerce-form__label woocommerce-form__label-for-checkbox inline">
                <input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme"
                       type="checkbox" value="forever"/>
                <span><?php esc_html_e( 'Remember me', 'razzi' ); ?></span>
            </label>
            <label class="form-row form-row-wide lost_password">
                <a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'razzi' ); ?></a>
            </label>
        </p>

        <p class="form-row form-row-wide">
			<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
            <button type="submit" class="razzi-button" name="login"
                    value="<?php esc_attr_e( 'Sign in', 'razzi' ); ?>"
                    data-signing="<?php esc_attr_e( 'Siging in...', 'razzi' ); ?>"
                    data-signed="<?php esc_attr_e( 'Signed In', 'razzi' ); ?>"><?php esc_html_e( 'Sign in', 'razzi' ); ?></button>

			<?php if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'yes' ) : ?>
                <span class="create-account razzi-button button-outline button-medium"><?php esc_html_e( 'Create An Account', 'razzi' ); ?></span>
			<?php endif; ?>
        </p>

		<?php do_action( 'woocommerce_login_form_end' ); ?>

    </form>

	<?php if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'yes' ) : ?>
        <?php
        $myaccount_page = get_option( 'woocommerce_myaccount_page_id' );
        if ( $myaccount_page ) {
            $request_url = get_permalink( $myaccount_page );
        } else {
            $request_url   = remove_query_arg( '_wp_http_referer' );
        }
        ?>

        <form action="<?php echo esc_url( $request_url ); ?>" method="post" class="woocommerce woocommerce-account woocommerce-form woocommerce-form-register register"
              style="display: none;">

			<?php do_action( 'woocommerce_register_form_start' ); ?>

			<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

                <p class="form-row form-row-wide">
                    <input placeholder="<?php  esc_attr_e( 'Username', 'razzi' );?>" type="text" class="input-text" name="username" id="panel_reg_username"
                           value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" required aria-required="true" /><?php // @codingStandardsIgnoreLine ?>
                </p>

			<?php endif; ?>

            <p class="form-row form-row-wide">
                <input placeholder="<?php  esc_attr_e( 'Email address', 'razzi' );?>" type="email" class="input-text" name="email" id="panel_reg_email"
                autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" required aria-required="true" /><?php // @codingStandardsIgnoreLine ?>
            </p>

			<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

                <p class="form-row form-row-wide">
                    <span class="password-input">
                        <input placeholder="<?php  esc_attr_e( 'Password', 'razzi' );?>" type="password" class="input-text" name="password" id="panel_reg_password" required aria-required="true" />
                    </span>
                </p>

			<?php endif; ?>

			<?php do_action( 'woocommerce_register_form' ); ?>

            <p class="form-row form-row-wide">
                <?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce', false, true ); ?>
                <?php
                echo sprintf('<input type="hidden" name="_wp_http_referer" value="%s" />', esc_url($request_url));
                ?>
                <button type="submit" class="razzi-button" name="register"
                        value="<?php esc_attr_e( 'Sign up', 'razzi' ); ?>"><?php esc_html_e( 'Sign up', 'razzi' ); ?></button>
            </p>

            <p class="form-row form-row-wide already_registered">
                <a href="#"
                   class="login razzi-button button-outline button-medium"><?php esc_html_e( 'Already has an account', 'razzi' ); ?></a>
            </p>

			<?php do_action( 'woocommerce_register_form_end' ); ?>

        </form>

	<?php endif; ?>
</div>
