<?php
/**
 * Template for displaying the add-to-wishlist button on the catalog page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/add-to-wishlist.php.
 *
 * @author  WCBoost
 * @package WCBoost\Wishlist\Templates
 * @version 1.1.5
 */

defined( 'ABSPATH' ) || exit;

global $product;

echo apply_filters(
	'wcboost_wishlist_loop_add_to_wishlist_link', // WPCS: XSS ok.
	sprintf(
		'<a href="%s" class="%s" %s data-text="%s" data-product-title="%s">' .
			( ! empty( $args['icon'] ) ? '<span class="wcboost-wishlist-button__icon">' . $args['icon'] . '</span>' : '' ) .
			'<span class="wcboost-wishlist-button__text">%s</span>' .
		'</a>',
		esc_url( isset( $args['url'] ) ? $args['url'] : add_query_arg( [ 'add-to-wishlist' => $product->get_id() ] ) ),
		esc_attr( isset( $args['class'] ) ? $args['class'] : 'wcboost-wishlist-button button' ),
		isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
		__( 'Wishlist', 'razzi' ),
		esc_attr( isset( $args['product_title'] ) ? $args['product_title'] : $product->get_title()),
		isset( $args['label'] ) ? esc_html( $args['label'] ) : esc_html__( 'Add to wishlist', 'razzi' )
	),
	$args
);
