<?php
/**
 * Single Product Thumbnails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-thumbnails.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.8.0
 */

use Razzi\WooCommerce\Helper;

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;

if ( ! $product || ! $product instanceof WC_Product ) {
	return '';
}

$attachment_ids = apply_filters('razzi_single_product_gallery_image_ids',$product->get_gallery_image_ids());
$video_index    = get_post_meta( $product->get_id(), 'video_position', true );
$index = 2;
$show_video = Razzi\Helper::get_option('product_play_video') == 'load' && is_singular( 'product' );
if ( $attachment_ids && $product->get_image_id() ) {
	foreach ( $attachment_ids as $key => $attachment_id ) {
		if( empty($attachment_id) ) {
			continue;
		}
		if ( $show_video && $index == $video_index ) {
			echo Helper::get_product_video();
		}

		echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', wc_get_gallery_image_html( $attachment_id, false, $key), $attachment_id ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped

		$index++;
	}

	if ( $show_video && $video_index > count($attachment_ids) ) {
		echo Helper::get_product_video();
	}
} else {
	if ( $show_video && $video_index > 1 ) {
		echo Helper::get_product_video();
	}

}